from matplotlib import pyplot as plt
import torch
import os
from utils.loadcolor import loadcolor

def getfigt(plott, plotf, config_yaml, logpath, yname):
    savename = config_yaml["log"]["savename"]

    histf1 = torch.round(plotf[0].to('cpu') * 100) / 100
    histf2 = torch.round(plotf[1].to('cpu') * 100) / 100
    histf3 = torch.round(plotf[2].to('cpu') * 100) / 100
    histt1 = plott[0].to('cpu')
    histt2 = plott[1].to('cpu')
    histt3 = plott[2].to('cpu')

    pcolor = loadcolor()
    plt.figure(figsize=(8, 6), dpi=80, facecolor='w')
    plt.subplots_adjust(left=0.15, right=0.9, bottom=0.15, top=0.9)

    plt.plot(histt1.detach().numpy(), histf1.detach().numpy(), '-', linewidth=5, markersize=3, color=pcolor['purple'].numpy(), label='J-JOBCD')
    plt.plot(histt2.detach().numpy(), histf2.detach().numpy(), '-', linewidth=5, markersize=3, color=pcolor['green'].numpy(), label='VR-J-JOBCD')
    plt.plot(histt3.detach().numpy(), histf3.detach().numpy(), '-', linewidth=5, markersize=3, color=pcolor['blue'].numpy(), label='CSDM')

    hleg = plt.legend(fontsize=15,frameon=True, framealpha=1)
    hleg.set_title('', prop={'size': 15, 'weight': 'normal', 'family': 'times new Roman'})
    hleg.get_title().set_fontsize('15')

    plt.xlabel('Time (seconds)', fontsize=20)
    plt.ylabel(yname, fontsize=20)
    plt.xticks(fontsize=17)
    plt.yticks(fontsize=17)

    plt.grid(True)
    # plt.axis([min(tss), max(tss), 0, torch.max(new_fs).detach().numpy()])

    plt.savefig(os.path.join(logpath, yname+'t{}.png'.format(savename)), format='png', dpi=300)
    plt.savefig(os.path.join(logpath, yname+'t{}.eps'.format(savename)), format='eps', dpi=300)

    plt.show()

